﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.UI;

namespace Framework.Web.UI
{
    public static class UIExtension
    {
        /// <summary>
        /// T型の最初の親コントロールを返します。
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="target"></param>
        /// <returns></returns>
        public static T FindParentControl<T>(this Control target) where T : Control
        {
            var func = (Func<Control, T>)null;
            func = new Func<Control, T>(c =>
                {
                    if (c == null)
                    {
                        return null;
                    }

                    var pc = c.Parent;

                    var t = pc as T;
                    if (t != null)
                    {
                        return t;
                    }

                    return func(pc);
                });

            return func(target);
        }
    }
}
